/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import website.eccentric.tome.Configuration;
import website.eccentric.tome.Tag;

public class ModName {
    private static final Map<String, String> modNames = new HashMap<String, String>();
    public static final String PATCHOULI = "patchouli";

    public static String from(BlockState state) {
        return ModName.orAlias(state.m_60734_().getRegistryName().m_135827_());
    }

    public static String from(ItemStack stack) {
        String mod = stack.m_41720_().getCreatorModId(stack);
        if (mod.equals(PATCHOULI)) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return PATCHOULI;
            }
            String book = tag.m_128461_(Tag.Patchouli.BOOK);
            mod = new ResourceLocation(book).m_135827_();
        }
        return ModName.orAlias(mod);
    }

    public static String orAlias(String mod) {
        return Configuration.ALIAS_MAP.getOrDefault(mod, mod);
    }

    public static String name(String mod) {
        return modNames.getOrDefault(mod, mod);
    }

    static {
        for (IModInfo mod : ModList.get().getMods()) {
            modNames.put(mod.getModId(), mod.getDisplayName());
        }
    }
}

